; Driveway Sentry Alert

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB3  & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF


; Define variables at memory locations

; Bank 0 RAM
POS_RESET_READ_LS equ H'20'	; positive reset reading least significant value
POS_RESET_READ_MS equ H'21'	; positive reset reading most significant value

NEG_RESET_READ_LS equ H'22'	; negative reset reading least significant value
NEG_RESET_READ_MS equ H'23'	; negative reset reading most significant value

TEMP0_MS	      equ H'24'	; temporary0 most significant value	
TEMP0_LS		  equ H'25'	; temporary0 least significant value	
TEMP1_MS		  equ H'26'	; temporary1 most significant value	
TEMP1_LS		  equ H'27'	; temporary1 least significant value	
TEMP_PWM_MS		  equ H'28'	; ms working register for PWM
TEMP_PWM_LS		  equ H'29'	; ls working register for PWM

START_FLG		  equ H'2A'	; start flag to allow for adaptive tracking presets
WDT_CNTR1		  equ H'2B'	; watchdog counter1 for initial startup
WDT_CNTR2		  equ H'2C'	; watchdog counter2 for adaptive threshold	
ADAPT_LEVEL_MS	  equ H'2D'	; adaptive level tracks neasured output at slow rate
ADAPT_LEVEL_LS	  equ H'2E'	; adaptive level tracks neasured output at slow rate

THRESHOLD_UP_MS	  equ H'2F'; upper threshold ms byte
THRESHOLD_UP_LS	  equ H'30'; upper threshold ls byte
THRESHOLD_LOW_MS  equ H'31'; upper threshold ms byte
THRESHOLD_LOW_LS  equ H'32'; upper threshold ls byte

STORE1			  equ H'33'	; timer store
STORE2			  equ H'34'	; timer store		
STORE3			  equ H'35'	; delay extension

EXIT_ENTRY_CODE	  equ H'36'	; transmit exit or entry code 
ID_MS			  equ H'37'	; identity value ms byte
ID_LS			  equ H'38'	; identity value ls byte

TEMP			  equ H'39'	; temporary 
TRANS_REPEAT	  equ H'3A'	; UHF transmit repeat value

NO_DETECT_CNTR	  equ H'3B'	; no detection counter	

PULSE_COUNTR	  equ H'3C'	; pulses counter for set & reset cycle					

SWAP_SET		  equ H'3D'	; status of swap link (stored here)compared for any change in setting
FLIP			  equ H'3E'	; alternate colour LED flashing 	
B_STORE_LOW		  equ H'3F'	; storage of portB levels
B_STORE_HI		  equ H'40'	; store portB levels		
DETECT_HI	  	  equ H'41'	; high detection	
DETECT_LO	  	  equ H'42'	; low detection	
OVER_RANGE		  equ H'43'	; over range flag allows set reset and checking min/max levels repeatedly

; all banks 
FAST			  equ H'70'	; faster watchdog/sensor sample rate for a faster driveway

	org	0	

; *************************************************
SETUP	
; set RA outputs low except for;
; PORTA,3 high (Q4 off), 
	movlw	B'00001000'
	movwf	PORTA
	
; set RB outputs low except for;
; RB0 (Q2 off),RB2 (Q3 off), RB4 (prevent Link pullup current) high, 
	movlw	B'00010101'
	movwf	PORTB

; set inputs/outputs
	
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11100000'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	movlw	B'00000000'	; 
	movwf	OPTION_REG	; pullups enabled 
	movlw   B'00100101'	; I/O 
	movwf   TRISA		; port A data direction register
; analog inputs, A/D
	movlw	B'00000101'	; AN0,AN2 analog input 
	movwf	ANSEL
	movlw	B'11000000'	; right justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01010000'	; Fosc, channel 2 (bit 4 set) etc
	movwf	ADCON0
; oscillator
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01110000'	; for 8MHz
	movwf	OSCCON		; osc

; pwm set
	movlw	D'255'		; 7.8kHz
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0

	clrf	CCPR1L		; ms byte of PWM
	bsf		CCPR1L,7	; set at 50%
	bcf		CCP1CON,4	; ls bit cleared
	bcf		CCP1CON,5	
; set the same as stored PWM values
	clrf	TEMP1_MS
	bsf		TEMP1_MS,7
	bcf		TEMP1_LS,4
	bcf		TEMP1_LS,5

	movlw	B'00000000'	; /1
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation


; watchdog timer (WDT)
; bits 4-1 timer period settings for sensor sampling rate
;0111 = 1:4096 for 131ms * this is the setting for ID 5-8
;1000 = 1:8192 for 262ms * this is the setting used for ID 0-4
;1001 = 1:16394 for 524ms

; alter watchdog timer rate with identity
; switch on transmitter and VR3
	clrf	FAST		; start by clearing faster flag
	bcf		PORTA,3		; Q4 on
; read AN0 for Identity VR3 setting.	
	movlw	B'01000000'	; Fosc, channel 0  etc
	movwf	ADCON0
	call	ACQUIRE_AD	; ; result: ADRESH (MS bits) and ADRESL is in w
	movwf	ID_LS		; ID (Identity) ls byte
	movf	ADRESH,w
	movwf	ID_MS		; ID (Identity) ms byte
; return A/D to channel 2
	movlw	B'01010000'	; Fosc, channel 2  etc
	movwf	ADCON0
	bsf		PORTA,3		; Q4 off
; move ms bits to ls byte (10 bits to 8-bits)
	rrf		ID_MS,f
	rrf		ID_LS,f
	bcf		STATUS,C	; clear carry
	rrf		ID_MS,f
	rrf		ID_LS,w
	andlw	B'11100000'	; use ms 3-digits for 8 selections
	movwf	ID_LS		; identity value selected with VR3
; if bit 7 set in ID_LS then set bit 0 in FAST
	btfsc	ID_LS,7
	bsf		FAST,0

	bsf		STATUS,RP1	; bank 2
	btfss	FAST,0
	movlw	B'00010000'	; for bits 4-1. watchdog / for repeat measurement. When bit 0 is set = watchdog on
	btfsc	FAST,0		; if fast flag is set use faster rate (FAST is in all banks ram)
	movlw	B'00001110'
	movwf	WDTCON		; watchdog timer on
	bcf		STATUS,RP1	; back to bank 0
; initial conditions
	clrf	WDT_CNTR2	; watchdog counter for adaptive level rate 	
	clrf	START_FLG	; start flag to allow for adaptive tracking presets
	clrf	NO_DETECT_CNTR	; no detection counter
	clrf	PULSE_COUNTR; pulses counter for set & reset cycle
	clrf	DETECT_HI	; high detection	
	clrf	DETECT_LO	; low detection

; nil detection startup period
; 
	movlw	D'35' 		; value x (sampling rate (WDT) +20ms) eg D'35' x (262ms + 20ms) = 10s
	btfsc	FAST,0		; if fast flag is set use a larger value
	movlw	D'70' 		; value x (sampling rate (WDT) +20ms) eg D'70' x (131ms + 20ms) = 10s
	movwf	WDT_CNTR1	; watchdog counter countdown	

;______________________________________________________

LOOP
; check if a detection
; slower sample rate if second detection
	btfsc	DETECT_HI,1	; if set second detection
	goto	SLOWER
	btfsc	DETECT_LO,1	; if set second detection
	goto	SLOWER
; first detection speed up sample rate
	btfsc	DETECT_HI,0	; if set
	goto	SPEED
	btfsc	DETECT_LO,0	; if set
	goto	SPEED
SLOWER
; watchdog timer (WDT)
; bits 4-1 timer period settings for sensor sampling rate
; 1000 = 1:8192 for 262ms
; 0111 = 1:4096 for 131ms 
	bsf		STATUS,RP1	; bank 2
	movlw	B'00010000'	; for bits 4-1. watchdog / for repeat measurement. When bit 0 is set = watchdog on; 262ms
	btfsc	FAST,0		; if fast flag is set use faster rate (all banks ram)
	movlw	B'00001110'	; 131ms
	movwf	WDTCON		; watchdog timer on
	bcf		STATUS,RP1	; back to bank 0
	goto	POWER_DOWN
; if a detect then speed up sampling
SPEED
; watchdog timer (WDT)
; bits 4-1 timer period settings for sensor sampling rate
;0110 = 1: 2048 for 65.5ms 
; 65.5ms
	bsf		STATUS,RP1	; bank 2
	movlw	B'00001100'	; for bits 4-1. watchdog / for repeat measurement. When bit 0 is set = watchdog on	
	movwf	WDTCON		; watchdog timer on
	bcf		STATUS,RP1	; back to bank 0
; prevent set/reset pulses when detection is in progress
; keep counter topped up
	movlw	D'35'		; run set/reset pulses every 10s
	movwf	PULSE_COUNTR	; set at 1/35	

POWER_DOWN
; shutdown power
	clrwdt	; clear watchdog timer
	bsf		STATUS,RP1	; bank 2
	bsf		WDTCON,0	; watchdog timer on
	bcf		STATUS,RP1	; back to bank 0
	movf	PORTB,w
	iorlw	B'00010111'	; RB2 high to switch off Q3 that powers sensor and IC1, RB4 high links pulldown off
	movwf	PORTB
	bsf		PORTA,3		; switch off TX module power
	call	DELAY1		; time for PWM off	
	sleep	;(wakes with watchdog timer timeout)
	nop 
; restore power	
	bcf		PORTB,2		; Q3 on powering op amp and sensor

; restore PWM (ie return the reference drive to op amp)
;	movf	TEMP1_MS,w	; ** use 255 instead
	movlw	D'255'		; (was movf TEMP1_MS,w.
; Use full ms bytes PWM (ignoring state of the least significant bits) to start up PWM filter
	movwf	CCPR1L		; correct PWM restored later
	btfsc	TEMP1_LS,4
	bsf		CCP1CON,4
	btfsc	TEMP1_LS,5
	bsf		CCP1CON,5

; watchdog timer off
	bsf		STATUS,RP1	; bank 2
	bcf		WDTCON,0	; watchdog timer off
	bcf		STATUS,RP1	; back to bank 0

; ****************************************************************

PULSES ; reset pulses for sensor
	movf	OVER_RANGE,w; over range flag shows flashing red and green LED for signal overload
; if zero then run as normal with set/resets periodically otherwise repeat set/reset
	btfss	STATUS,Z
	goto	DIAGNOSTICS
; set/ reset pulse counter (rate for set/ reset)
	movf	PULSE_COUNTR,w ; pulses counter for set & reset cycle
	btfss	STATUS,Z	; run set/reset pulses when cleared
	goto	DETECT2
	movlw	D'35'		; run set/reset pulses every 10s (1/35)
	btfsc	FAST,0		; if fast flag is set use a larger value
	movlw	D'70' 		; run set/reset pulses every 10s (1/70)
	movwf	PULSE_COUNTR	; set at 1/35 or 1/70	
	
DIAGNOSTICS 
; test for a 'swap to exit' link connection
; where VR3 is powered to allow setting of the transmission ID
; also a diagnostic setting for PWM and powering IC1 and sensor

; this is a connection between RB5 and RB6

; RB5 and RB6 need to be both high if RB5 and RB6 are connected

	bcf		PORTB,4		; enable the low connection for RB5 and RB6 if connected to RB4
	nop
	nop
	btfss	PORTB,6
	goto	PULSES_1
	btfss	PORTB,5
	goto	PULSES_1

; Set RB6 as an output and RB4 as an input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'10110000'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
; for an RB5 to RB6 connection RB5 needs to be high with RB6 high and low with RB6 low
; low
	bcf		PORTB,6
	nop
	nop
; read portB and store for access to RB5 level
	movf	PORTB,w
	movwf	B_STORE_LOW
; hi
	bsf		PORTB,6
	nop
	nop
; read portB and store for access to RB5 level
	movf	PORTB,w
	movwf	B_STORE_HI
	
;  set RB6 as an input RB4 as an output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11100000'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

	btfsc	B_STORE_LOW,5	; if low then check alternative PORTB level power VR3
	goto	PULSES_1
	btfss	B_STORE_HI,5	; if high then run diagnostics
	goto	PULSES_1
 
; run diagnostics
; Q3 powered (earlier), allows Vout measurement/monitoring
	bcf		PORTA,3		; Q4 on to allow ID to be monitored
; set the required PWM value
	movf	TEMP1_MS,w
	movwf	CCPR1L
; LEDs off
	bsf		PORTA,4
	nop
	nop
	bsf		PORTA,6
	goto	DIAGNOSTICS	; run until link is out

PULSES_1
	bcf		PORTB,1		; Q1 off
	bsf		PORTA,3		; Q4 off
	bsf		PORTB,4		; links off
	nop
	nop
;1. Pulse set and reset strap & measure reading
; positive reset
	bcf		PORTB,0 	; positive pulse P-channel Mosfet Q2 on

; drive at full PWM for a short period to charge offset capacitor
	movlw	D'50'
	call	DELAY2
; now use the required PWM value
	movf	TEMP1_MS,w
	movwf	CCPR1L

; wait, delay for pulse and PWM to restore
	movlw	D'35'
 	movwf	STORE3
DELAY_LOOP1
	call	DELAY1
	decfsz	STORE3,F
	goto	DELAY_LOOP1

	bsf		PORTB,0		; stop current flow, positive pulse P-channel Mosfet Q2 off

; read AN2 for positive reset reading	
	movlw	B'01010000'	; Fosc, channel 2  etc
	movwf	ADCON0

	call	ACQUIRE_AD	; result in w
; result: ADRESH (MS bits) and ADRESL is in w
	movwf	POS_RESET_READ_LS	; positive reset reading least significant value
	movf	ADRESH,w
	movwf	POS_RESET_READ_MS	; positive reset reading most significant value

; negative reset
	bsf		PORTB,1 	; negative pulse N-channel Mosfet Q1 on
; wait ; delay for pulse 
	movlw	D'25'
 	movwf	STORE3
DELAY_LOOP2
	call	DELAY1
	decfsz	STORE3,F
	goto	DELAY_LOOP2

	bcf		PORTB,1 	; stop current flow, negative pulse N-channel Mosfet Q1 off

; read AN2 for negative reset reading	
	movlw	B'01010000'	; Fosc, channel 2  etc
	movwf	ADCON0
	call	ACQUIRE_AD	; result: ADRESH (MS bits) and ADRESL is in w
;
	movwf	NEG_RESET_READ_LS	; negative reset reading least significant value
	movf	ADRESH,w
	movwf	NEG_RESET_READ_MS	; negative reset reading most significant value

	bsf		PORTB,2				; power off

; clear PWM  (ie set low) (Reference drive)	
	clrf	CCPR1L
	bcf		CCP1CON,4	; ls bit cleared
	bcf		CCP1CON,5	
	bsf		PORTB,1		; Q1 on
; -----------------------------------------------------
; show warning LED flashing if readings are within 0.3125V of the supply rails
; check if readings are above 4.68V (1111000000) (4.68 = 5-0.3125V)
	movf	NEG_RESET_READ_MS,w	; negative reset reading most significant value
	xorlw	B'00000011'
	btfss	STATUS,Z
	goto	NEG_LOW			; check if NEG_RESET_READ is low
	btfss	NEG_RESET_READ_LS,7	; if set then 1110000000 or more
	goto	NEG_LOW			; check if NEG_RESET_READ is low
	btfsc	NEG_RESET_READ_LS,6	; if set then 1111000000 or more
	goto	WARNING			; readings too high or low
NEG_LOW
; check if readings are below 0.3125V (0001000000)
	movf	NEG_RESET_READ_MS,w	; negative reset reading most significant value. When zero could be below 
	btfss	STATUS,Z
	goto	COMPARE_SWAP
	movf	NEG_RESET_READ_LS,w	; 
	sublw	B'01000000'
	btfss	STATUS,C
	goto	COMPARE_SWAP
WARNING
	bsf		OVER_RANGE,0	; over range flag
; flash LEDS
	btfss	FLIP,0
	goto	FLIP_LED
	bcf		PORTA,4
	bsf		PORTA,6		; green LED
; wait, delay for LED flash
WAIT_1
	incf	FLIP,f		; change LED
	movlw	D'50'
	movwf	STORE3
DELAY_LOOP0
	call	DELAY1
	decfsz	STORE3,F
	goto	DELAY_LOOP0
	bsf		PORTA,4		; LED off
	bsf		PORTA,6
	goto	LOOP
FLIP_LED
; flash LEDS
	bcf		PORTA,6
	bsf		PORTA,4		; red LED
	goto	WAIT_1	

;--------------------------------------------------------------	
; compare swap status. Transfer reading to adaptive level if swap setting has changed
COMPARE_SWAP
	clrf	OVER_RANGE	; over range flag
	bcf		PORTB,4		; allow links to be read
	nop
	nop
	movf	PORTB,w
	bsf		PORTB,4		; links off
	andlw	B'00100000'	; single out swap bit 5
	xorwf	SWAP_SET,w	; compare portb,5 the swap position with stored status of swap link
	btfsc	STATUS,Z
	goto	OFFSET_CALCULATION	; the same so no change in swap link position
; different swap position so reload 

; read SWAP link setting
	bcf		PORTB,4		; allow links to be read
	nop
	nop
	movf	PORTB,w
	bsf		PORTB,4		; links off
	andlw	B'00100000'
	movwf	SWAP_SET	; store portb,5 is the swap link position

; transfer readings to adaptive level	
	movf	NEG_RESET_READ_MS,w ; output
	movwf	ADAPT_LEVEL_MS	; adaptive level
	movf	NEG_RESET_READ_LS,w
	movwf	ADAPT_LEVEL_LS

; -----------------------------------------------------------
OFFSET_CALCULATION; find sensor offset

; add NEG_RESET_READ_MS/LS & POS_RESET_READ_MS/LS 
; then divide by 2 = offset
	movf	POS_RESET_READ_MS,w
	addwf	NEG_RESET_READ_MS,w
	movwf	TEMP0_MS				; add ms bytes store in temp
	movf	POS_RESET_READ_LS,w
	addwf	NEG_RESET_READ_LS,w
	movwf	TEMP0_LS				; add ls bytes store in temp
	btfsc	STATUS,C			; if over
	incf	TEMP0_MS,f
; divide by 2
	bcf		STATUS,C
	rrf		TEMP0_MS,f			; get offset ms byte
	rrf		TEMP0_LS,f			; offset ls byte

; adjust reference drive so it is centred (ie at 512 for 10-bit PWM (2.5V for 5V swing))
; check if under or over 512
	btfss	TEMP0_MS,1			; if set then 512 or more 
	goto	LESS
	bcf		TEMP0_MS,1			; subtract 512 (ie remove the 512 bit)

; check if zero
	movf	TEMP0_MS,w
	btfss	STATUS,Z
	goto	SHFT_PWM
	movf	TEMP0_LS,w
	btfsc	STATUS,Z	
	goto	LOOP;DETECT1	;;			; bypass if zero
 
; TEMP_MS,LS is offset above 512
SHFT_PWM
	call	PWM_SHIFT			; convert TEMP1_LS/MS to right justified TEMP_PWM_MS,LS

; reduce PWM by 1

	movlw	D'1'
	subwf	TEMP_PWM_LS,f
	btfsc	STATUS,C			; if over
	goto	PWM_CALL
	
	movlw	D'1'
	subwf	TEMP_PWM_MS,f
	btfsc	STATUS,C			; if carry set at 0
	goto	PWM_CALL
	clrf	TEMP_PWM_LS
	clrf	TEMP_PWM_MS
	
PWM_CALL
	call	DRV_PWM				; convert right justified TEMP_PWM_MS,LS to TEMP1_LS/MS
	goto	LOOP				; was DETECT1

LESS ; 

; offset below 512
	call	PWM_SHIFT			; convert TEMP1_LS/MS to right justified TEMP_PWM_MS,LS

; increase PWM 

	movlw	D'1'
	addwf	TEMP_PWM_LS,f
	btfsc	STATUS,C
	incf	TEMP_PWM_MS,f
	call	DRV_PWM				; convert right justified TEMP_PWM_MS,LS to TEMP1_LS/MS
	goto	LOOP				; was DETECT1

DETECT2
	decf	PULSE_COUNTR,f	; reduce pulse counter value each time
; drive at full PWM for a short period to charge offset capacitor
	movlw	D'50'
	call	DELAY2
; return to correct PWM value
	movf	TEMP1_MS,w
	movwf	CCPR1L
; wait ; delay for PWM to restore
	movlw	D'35'
 	movwf	STORE3
DELAY_LOOP3
	call	DELAY1
	decfsz	STORE3,F
	goto	DELAY_LOOP3

; read AN2 for negative reset reading	
	movlw	B'01010000'	; Fosc, channel 2  etc
	movwf	ADCON0
	call	ACQUIRE_AD	; result: ADRESH (MS bits) and ADRESL is in w

	movwf	NEG_RESET_READ_LS	; negative reset reading least significant value
	movf	ADRESH,w
	movwf	NEG_RESET_READ_MS	; negative reset reading most significant value

DETECT1
;  clear PWM (ie set low) (Reference drive)	

	clrf	CCPR1L
	bcf		CCP1CON,4	; ls bit cleared
	bcf		CCP1CON,5

	bsf		PORTB,2				; power off

; use NEG_RESET_READ_MS and NEG_RESET_READ_LS as output (RTM (REAL TIME MEASUREMENT) samples each ~150ms with watchdog at 130ms)
; AL (Adaptive Level) tracks RTM but at slow rate (ie changes are limited to 1 lsb per x samples)
; incorporate an upper and lower threshold for detection use counts of 10 above and 10 below 
; A low before high RTM = entry direction
; a high before low RTM = exit direction
; start flag allows initial settings where RTM = AL
; START_FLG		  	; start flag to allow for adaptive tracking presets
; WDT_CNTR1		  	; watchdog counter1 for initial startup
; WDT_CNTR2			; watchdog counter2 for adaptive tracking	
; ADAPT_LEVEL_MS	; adaptive level	
; ADAPT_LEVEL_LS	; adaptive level	

ADAPT
	btfsc	START_FLG,1	; if clear, load initial adaptive level
	goto	ADAPT_NOW

; transfer readings to adaptive level	

	movf	NEG_RESET_READ_MS,w ; output
	movwf	ADAPT_LEVEL_MS	; adaptive level
	movf	NEG_RESET_READ_LS,w
	movwf	ADAPT_LEVEL_LS
	incf	START_FLG,f		; set flag to bypass initial loading of adaptive level

ADAPT_NOW
; do adaptive changes
; compare adaptive level AL to RTM (real time measurement) 
	movf	NEG_RESET_READ_MS,w ; output
	xorwf	ADAPT_LEVEL_MS,w
	btfss	STATUS,Z			; if the same compare ls byte
	goto	COMPARE
	movf	NEG_RESET_READ_LS,w ; output
	xorwf	ADAPT_LEVEL_LS,w
	btfsc	STATUS,Z			; if the same compare ls byte
	goto	COUNTDOWN

; see if AL is less than or greater than RTM
COMPARE
; increase or decrease (adjust to follow at 1 lsb per x samples)
	movf	NEG_RESET_READ_MS,w ; output
	subwf	ADAPT_LEVEL_MS,w
	movwf	TEMP0_MS
	movf	NEG_RESET_READ_LS,w ; output
	subwf	ADAPT_LEVEL_LS,w
	btfss	STATUS,C
	decf	TEMP0_MS,f
	btfsc	TEMP0_MS,7
	goto	increase
decrease
; extension of adaption period (also see 'NO_ADJUST')
	movf	WDT_CNTR2,w			; check watchdog timeout counter
	btfss	STATUS,Z
	goto	NO_ADJUST
	movlw	D'05'				; adaptive rate
	movwf	WDT_CNTR2
	
; reduce adaptive level
	movlw	D'1'
	subwf	ADAPT_LEVEL_LS,f	; take away 1
	btfsc	STATUS,C			; if carry, reduce ms byte
	goto	COUNTDOWN
	movlw	D'1'
	subwf	ADAPT_LEVEL_MS,f
	btfsc	STATUS,C			; if carry set at 0
	goto	COUNTDOWN
	clrf	ADAPT_LEVEL_LS
	clrf	ADAPT_LEVEL_MS
	goto	COUNTDOWN

increase
; extension of adaption period (also see 'NO_ADJUST'decf	WDT_CNTR2,f)
	movf	WDT_CNTR2,w			; check watchdog timeout counter
	btfss	STATUS,Z
	goto	NO_ADJUST
	movlw	D'05'				; adaptive rate
	movwf	WDT_CNTR2

; increase adaptive level
	movlw	D'1'
	addwf	ADAPT_LEVEL_LS,f	; add 1
	btfss	STATUS,C			; if carry, add to ms byte
	goto	COUNTDOWN
	incf	ADAPT_LEVEL_MS,f
	btfss	ADAPT_LEVEL_MS,2	; if over 1024 keep at 1024
	goto	COUNTDOWN
	movlw	H'FF'
	movwf	ADAPT_LEVEL_LS
	movlw	B'00000011'
	movwf	ADAPT_LEVEL_MS
	goto	COUNTDOWN
NO_ADJUST
	decf	WDT_CNTR2,f	 		; watchdog counter decrease (sets rate at which adaptive level is changed with signal)
; countdown watchdog initial counter
COUNTDOWN

; check if initial startup period
	movf	WDT_CNTR1,w
	btfsc	STATUS,Z		; if zero continue
	goto	THRESHOLDS
	decf	WDT_CNTR1,f	
	goto	LOOP			; bypass detection till all ready

THRESHOLDS

; set thresholds 10 above and below adaptive level (AL)
; add 10 to AL and subtract 10 from AL

; set lower threshold
	movlw	D'5'				; 24mV (10=~49mV)

	subwf	ADAPT_LEVEL_LS,w	; take away 10
	movwf	THRESHOLD_LOW_LS	; adaptive threshold lower threshold ls bytes
	btfsc	STATUS,C			; if carry, reduce ms byte
	goto	SET_MS_THRESH_LOWER
	movlw	D'1'
	subwf	ADAPT_LEVEL_MS,w
	movwf	THRESHOLD_LOW_MS
	btfsc	STATUS,C			; if carry, set at 0
	goto	UPPER_THRESH
	clrf	THRESHOLD_LOW_LS
	clrf	THRESHOLD_LOW_MS
	goto	UPPER_THRESH
SET_MS_THRESH_LOWER
	movf	ADAPT_LEVEL_MS,w
	movwf	THRESHOLD_LOW_MS

UPPER_THRESH
; set upper threshold
	movlw	D'5'				; 24mV (10=~49mV)

	addwf	ADAPT_LEVEL_LS,w	; add 10
	movwf	THRESHOLD_UP_LS	    ; upper threshold ls byte
	btfss	STATUS,C			; if carry, add to ms byte
	goto	SET_MS_THRESH_UPPER
	movlw	D'1'
	addwf	ADAPT_LEVEL_MS,W
	movwf	THRESHOLD_UP_MS
	btfss	THRESHOLD_UP_MS,2	; if over 1024 keep at 1024
	goto	DETECT
	movlw	H'FF'
	movwf	THRESHOLD_UP_LS
	movlw	B'00000011'
	movwf	THRESHOLD_UP_MS	
	goto	DETECT
SET_MS_THRESH_UPPER
	movf	ADAPT_LEVEL_MS,w
	movwf	THRESHOLD_UP_MS

DETECT

; check detection of RTM level against thresholds 
; NEG_RESET_READ_MS and NEG_RESET_READ_LS are the RTM levels
; 1. is RTM above upper threshold?

	movf	NEG_RESET_READ_MS,w ; output
	subwf	THRESHOLD_UP_MS,w
	movwf	TEMP0_MS
	movf	NEG_RESET_READ_LS,w ; output
	subwf	THRESHOLD_UP_LS,w
	btfss	STATUS,C
	decf	TEMP0_MS,f
	btfss	TEMP0_MS,7
	goto	DET_LO

; above high Threshold

; ------------------------
; direction detection coding
	btfsc	DETECT_LO,0		; if detect lo, bit 0 is set, then bypass
	goto	BYPASS
	btfsc 	DETECT_HI,0		; more than the first detection required
	goto	ABOVE_HI		; more than one detection so do detect
	bsf		DETECT_HI,0		; set bit 0
	goto	BYPASS			; wait for another detection (DETECT_HI is cleared each non detect)	

ABOVE_HI
	bsf		DETECT_HI,1		; second detection
; when NO_DETECT_CNTR is zero then a new detection
	movf	NO_DETECT_CNTR,w
	btfss	STATUS,Z
	goto	BY_LOW_HI_DETECT
; whenever a new detection with NO_DETECT_CNTR initially at zero, set the no detect counter
	movlw	D'16'
	movwf	NO_DETECT_CNTR ; no detection counter ~300ms x value

; links selection
	bcf		PORTB,4	; set links driver low
	nop
	nop
	
; check if detection is swapped (RB5 low)
 	btfss	PORTB,5
	goto	GREEN	; detection sense swapped	
RED; (EXIT detection)
; red LED
	bcf		PORTA,6
	nop
	nop
	bsf		PORTA,4
	bsf		PORTB,4	; set links driver high
 	goto	TRANSMIT_EXIT	; send UHF signal to receiver

DET_LO	
; 2. is RTM below lower threshold?
	movf	NEG_RESET_READ_MS,w ; output
	subwf	THRESHOLD_LOW_MS,w
	movwf	TEMP0_MS
	movf	NEG_RESET_READ_LS,w ; output
	subwf	THRESHOLD_LOW_LS,w
	btfss	STATUS,C
	decf	TEMP0_MS,f
	btfsc	TEMP0_MS,7
	goto	DETECT_OFF

; below low Threshold

; -------------------
; direction detection coding
	btfsc	DETECT_HI,0		; if detect hi, bit 0 is set, then bypass
	goto	BYPASS
	btfsc 	DETECT_LO,0		; more than the first detection required
	goto	BELOW_LOW		; more than one detection so do detect
	bsf		DETECT_LO,0		; set bit 0
	goto	BYPASS			; wait for another detection (DETECT_LO is cleared each non detect)	

BELOW_LOW
	bsf		DETECT_LO,1		; second detection
; when NO_DETECT_CNTR is zero then a new detection
	movf	NO_DETECT_CNTR,w
	btfss	STATUS,Z
	goto	BY_LOW_HI_DETECT
; whenever a new detection with NO_DETECT_CNTR initially at zero, set the no detect counter
	movlw	D'16'
	movwf	NO_DETECT_CNTR ; no detection counter ~300ms x value

; ----------------------
	
; links selection
	bcf		PORTB,4	; set links driver low
	nop
	nop
; check if detection is swapped (RB5 low)
	btfss	PORTB,5
	goto	RED		; detection sense swapped
GREEN ; (ENTRY detection)
; green LED
	bsf		PORTA,6
	nop
	nop
	bcf		PORTA,4
	bsf		PORTB,4	; set links driver high
	goto	TRANSMIT_ENTRY	; send UHF signal to receiver

BY_LOW_HI_DETECT
; whenever a detection, set the no detect counter
	movlw	D'16'
	movwf	NO_DETECT_CNTR ; no detection counter ~300ms x value
	goto	BYPASS

; --------------------------------------
DETECT_OFF

; check no detection counter
; if the NO_DETECT_CNTR is at zero, switch LEDs off
	movf	NO_DETECT_CNTR,w ; no detection counter
	btfsc	STATUS,Z
	goto	LEDS_OFF
	decfsz	NO_DETECT_CNTR,f
	goto	BYPASS
; clear detect flags
LEDS_OFF
	clrf	DETECT_HI
	clrf	DETECT_LO
; ----------------------------------------	

; switch LEDs off
; LEDS_OFF
	bsf		PORTA,4
	nop
	nop
	bsf		PORTA,6
	goto	LOOP
; ------------------------------------------
 
TRANSMIT_EXIT

; check if exit is selected
	bcf		PORTB,4		; set links driver low
	nop
	nop
; check if detection is for exit (RB6 low)

	btfss	PORTB,6	
	goto	SEND_EXIT

; exit detection not selected but could be non-directional detection
; check RB7 (entry) for a low
	btfss	PORTB,7
	goto	BYPASS
NON_DIR
; check if there is the non-direction selection (ie exit/entry direction becomes a non-directional detection)
; this is a connection between RB6 and RB7
; Set RB7 as an output and RB4 as an input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01110000'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
; RB6 should follow RB7 hi and low
; low
	bcf		PORTB,7
	nop
; read portB and store for access to RB6 level
	movf	PORTB,w
	movwf	B_STORE_LOW
; hi
	bsf		PORTB,7
	nop
; read portB and store for access to RB6 level
	movf	PORTB,w
	movwf	B_STORE_HI

;  set RB7 as an input RB4 as an output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11100000'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

	btfsc	B_STORE_LOW,6	; if low then possibly the non-direction setting selected	
	goto	BYPASS
	btfsc	B_STORE_HI,6	; if high then non-directional setting selected
	goto	TRANSMIT_DETECT
	goto 	BYPASS

; send UHF exit code
SEND_EXIT
	bsf		PORTB,4 
	movlw	H'55'
	movwf	EXIT_ENTRY_CODE	; transmit exit or entry code 
	goto	TRANSMIT_CODE

TRANSMIT_ENTRY

; check if entry is selected
	bcf		PORTB,4		; set links driver low
; check if detection is for entry (RB7 low)
	nop
	nop
 	btfss	PORTB,7	
	goto	SEND_ENTRY	
; entry detection not selected but could be non-directional detection
; check RB6 (exit for a low)
	btfss	PORTB,6
	goto	BYPASS
	goto	NON_DIR	; check for non-directional setting


SEND_ENTRY
; send UHF entry code
	bsf		PORTB,4
	movlw	H'33'
	movwf	EXIT_ENTRY_CODE	; transmit exit or entry code 
	goto	TRANSMIT_CODE

TRANSMIT_DETECT
; send UHF non-direction code
	movlw	H'99'
	movwf	EXIT_ENTRY_CODE	; transmit exit / entry or non-directional code 

TRANSMIT_CODE

; set transmit repeats
	movlw	D'3'		; repeats = Decimal'value' -1
	movwf	TRANS_REPEAT
;
TX_REPEAT
	decfsz	TRANS_REPEAT,f
	goto	XMIT
	movlw	D'250'
	call	DELAYXX
	goto 	TRANSMIT_ENDED 

XMIT	
; switch on transmitter and VR3
	bcf		PORTA,3		; Q4 on
; read AN0 for Identity VR3 setting.	
	movlw	B'01000000'	; Fosc, channel 0  etc
	movwf	ADCON0
	call	ACQUIRE_AD	; ; result: ADRESH (MS bits) and ADRESL is in w
	movwf	ID_LS		; ID (Identity) ls byte
	movf	ADRESH,w
	movwf	ID_MS		; ID (Identity) ms byte
; return A/D to channel 2
	movlw	B'01010000'	; Fosc, channel 2  etc
	movwf	ADCON0

; move ms bits to ls byte (10 bits to 8-bits)
	rrf		ID_MS,f
	rrf		ID_LS,f
	bcf		STATUS,C	; clear carry
	rrf		ID_MS,f
	rrf		ID_LS,w
	andlw	B'11100000'	; use ms 3-digits for 8 selections
	movwf	ID_LS		; identity value selected with VR3
; if bit 7 is set in ID_LS then set bit 0 in FAST
	clrf	FAST
	btfsc	ID_LS,7
	bsf		FAST,0

; send code via UHF
	call	SEND_DATA
	goto	TX_REPEAT	; check if retransmission required

TRANSMIT_ENDED 
; UHF transmitter data input low
	bcf		PORTA,1
	call	DELAY1
; switch off transmitter power and for VR3 and links driver
	bsf		PORTA,3	; Q4 off 
	bsf		PORTB,4	; links driver off
	goto	LOOP

BYPASS
	bsf		PORTB,4	; set links driver high
	goto	LOOP

; ******************************************************************************************************

; SUBROUTINES
; Send UHF Data
SEND_DATA
; start bits with gap for locking to data rate, encode value, 
; Entry/Exit code and stop bits


; start bits with gap for locking to data rate

; send out a 1 to engage the receiver

	bsf		PORTA,1		; send a 1
	movlw	D'200'		; 50 ms
	call	DELAYXX		; ms
	bcf		PORTA,1		; send a zero
	movlw	D'20'		; 5 ms 
	call	DELAYXX		; ms

; send a reference gap

	bsf		PORTA,1		; a 1
	movlw	D'64'		; 16ms 
	call	DELAYXX		; extra length
	bcf		PORTA,1		; a 0		
	movlw	D'4'
	call	DELAYXX

; start sending data
; encode 
; 8-bits
	movf	ID_LS,w		; send encode (identity)
	call	ROLL_8		; send out 

; ENTRY/EXIT code
; 8-bits
	movf	EXIT_ENTRY_CODE,w	; exit or entry code 		; 
	call	ROLL_8
; stop bits
; 8-bits
	movlw	D'142'		; send stop bits 
	call	ROLL_8

	movlw	D'40'
	call	DELAYXX		; 10ms
; power off mode
	bcf		PORTA,1		; transmit input low
	bcf		PORTA,3		; power off
	return

; send out 8-bits
ROLL_8
	movwf	TEMP
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	return
SET_OUT
	btfss	STATUS,C	; if set send a 1
	goto	CLR_4
	bsf		PORTA,1
	movlw	D'4'
	call	DELAYXX
	return
CLR_4	
	bcf		PORTA,1
	movlw	D'4'
	call	DELAYXX
	return

; *********************************************************************

DRV_PWM ; Subroutine to convert right justified TEMP_PWM_MS,LS (for calculations) to left justified TEMP1_LS/MS (suits PWM)  
	bcf		TEMP1_LS,4
	btfsc	TEMP_PWM_LS,0
	bsf		TEMP1_LS,4		; set bit 4. bit 0 of 10-bits
	bcf		TEMP1_LS,5
	btfsc	TEMP_PWM_LS,1
	bsf		TEMP1_LS,5		; set bit 5. bit 1 of 10-bits
; shift 
	bcf		STATUS,C
	rrf		TEMP_PWM_MS,f
	rrf		TEMP_PWM_LS,f	; move ms to ls byte
	bcf		STATUS,C
	rrf		TEMP_PWM_MS,f
	rrf		TEMP_PWM_LS,w	; move ms to ls byte
	movwf	TEMP1_MS		; into PWM
	return

PWM_SHIFT
; subroutine; from TEMP1_MS (from CCPR1L), TEMP1_LS (from CCP1CON,5 CCP1CON,4)suiting PWM to TEMP_PWM_MS, TEMP_PWM_LS (for calculations)
; Shift PWM (TEMP1_MS, TEMP1_LS,4,5) to standard right justified 10-bit
	clrf	TEMP_PWM_MS		; ms cleared
	movf	TEMP1_MS,w		; pwm ms byte
	movwf	TEMP_PWM_LS
	bcf		STATUS,C
	rlf		TEMP_PWM_LS,f	; shift left
	rlf		TEMP_PWM_MS,f	; shift carry to ms byte
	bcf		STATUS,C
	rlf		TEMP_PWM_LS,f	; shift left
	rlf		TEMP_PWM_MS,f	; shift carry to ms byte	
; insert bits 0 and 1	
	btfsc	TEMP1_LS,4		; ls bit 0  
	bsf		TEMP_PWM_LS,0
	btfsc	TEMP1_LS,5		; ls bit 1  
	bsf		TEMP_PWM_LS,1
	return

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,ADON	; A/D on
	movlw	D'1'
	call	DELAY2
	bsf		ADCON0,2	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	bcf		ADCON0,ADON	; A/D off
	bsf		STATUS,RP0	; bank 1
	movf	ADRESL,w
	bcf		STATUS,RP0	; bank 0
	return

DELAY1
	movlw	D'8'	; 
DELAY2
	movwf	STORE1
LOOP2
	movlw	D'20'
	movwf	STORE2
LOOP1
	decfsz	STORE2,f
	goto	LOOP1
	decfsz	STORE1,f
	goto	LOOP2
	return

DELAYXX
	movwf	STORE3
DELAY_CYC
	call	DELAY1
	decfsz	STORE3,f
	goto	DELAY_CYC
	return

	end